<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RelativeInfo extends Model 
{

    protected $table = 'relative_infos';
    public $timestamps = true;
    protected $fillable = array('relative_name', 'relative_email', 'relative_dob', 'relation');

    public function history()
    {
        return $this->hasMany('App\Models\User', 'relative_id');
    }

    public function familyMember()
    {
        return $this->hasOne('App\Models\PossibleMembersList', 'relation');
    }

}